<?php

// Add the administrator field
if (self::$db_alter->fetch_table_info('administrator'))
{
	self::$db_alter->add_field(array(
		'name'       => 'dbtech_vbmailadminperms',
		'type'       => 'int',
		'length'     => '10',
		'attributes' => 'unsigned',
		'null'       => false,	// True = NULL, false = NOT NULL
		'default'    => '0'
	));
	self::report('Altered Table', 'administrator');
}

if (self::$db_alter->fetch_table_info('user'))
{
	self::$db->hide_errors();
	self::$db->query_write("ALTER TABLE " . TABLE_PREFIX . "user ADD dbtech_vbmail_bounceflag ENUM('0', '1') NOT NULL DEFAULT '0'");
	self::$db->show_errors();
	self::report('Altered Table', 'user');
}

if (self::$db_alter->fetch_table_info('usergroup'))
{
	self::$db_alter->add_field(array(
		'name'       => 'dbtech_vbmailpermissions',
		'type'       => 'int',
		'length'     => '10',
		'attributes' => 'unsigned',
		'null'       => false,	// True = NULL, false = NOT NULL
		'default'    => '0'
	));
	self::report('Altered Table', 'usergroup');
}

self::$db->query_write("
	CREATE TABLE IF NOT EXISTS `" . TABLE_PREFIX  . "dbtech_vbmail_keyword` (
		`keywordid` int(10) unsigned NOT NULL AUTO_INCREMENT,
		`title` varchar(50) NOT NULL DEFAULT '',
		`description` mediumtext,
		`active` enum('0','1') NOT NULL DEFAULT '1',
		`bitfield` int(10) unsigned NOT NULL DEFAULT '0',
		PRIMARY KEY (`keywordid`)
	) ENGINE=MyISAM
");
self::report('Created Table', 'dbtech_vbmail_keyword');

self::$db->query_write("
	CREATE TABLE IF NOT EXISTS `" . TABLE_PREFIX  . "dbtech_vbmail_mail` (
		`mailid` int(10) unsigned NOT NULL AUTO_INCREMENT,
		`mailinglistid` int(10) unsigned NOT NULL DEFAULT '0',
		`subject` varchar(250) NOT NULL,
		`message` mediumtext,
		`dateline` int(10) unsigned NOT NULL DEFAULT '0',
		PRIMARY KEY (`mailid`),
		KEY `mailinglistid` (`mailinglistid`)
	) ENGINE=MyISAM
");
self::report('Created Table', 'dbtech_vbmail_mail');

self::$db->query_write("
	CREATE TABLE IF NOT EXISTS `" . TABLE_PREFIX  . "dbtech_vbmail_mailinglist` (
		`mailinglistid` int(10) unsigned NOT NULL AUTO_INCREMENT,
		`title` varchar(50) NOT NULL DEFAULT '',
		`description` mediumtext,
		`active` enum('0','1') NOT NULL DEFAULT '1',
		`displayorder` INT( 10 ) UNSIGNED NOT NULL DEFAULT '0',
		`ownerid` INT( 10 ) UNSIGNED NOT NULL DEFAULT '0',
		`fromemail` char(100) NOT NULL DEFAULT '',
		`permissions` MEDIUMTEXT NULL DEFAULT NULL,
		`type` ENUM( '0', '1' ) NOT NULL DEFAULT '0',
		`bitfield` int(10) unsigned NOT NULL DEFAULT '0',
		PRIMARY KEY (`mailinglistid`)
	) ENGINE=MyISAM
");
self::report('Created Table', 'dbtech_vbmail_mailinglist');

self::$db->query_write("
	CREATE TABLE IF NOT EXISTS `" . TABLE_PREFIX  . "dbtech_vbmail_message` (
		`messageid` int(10) NOT NULL,
		`fromaddress` varchar(250) NOT NULL,
		`subject` varchar(250) NOT NULL,
		`headers` mediumtext,
		`body` mediumtext,
		`dateline` int(10) NOT NULL DEFAULT '0',
		`bounce` enum('0','1') NOT NULL DEFAULT '1',
		PRIMARY KEY (`messageid`),
		KEY `fromaddress` (`fromaddress`)
	) ENGINE=MyISAM
");
self::report('Created Table', 'dbtech_vbmail_message');

self::$db->query_write("
	CREATE TABLE IF NOT EXISTS `" . TABLE_PREFIX  . "dbtech_vbmail_subscription` (
		`userid` int(10) unsigned NOT NULL,
		`mailinglistid` int(10) unsigned NOT NULL,
		`subscribed` enum('0','1') NOT NULL DEFAULT '1',
		PRIMARY KEY (`userid`,`mailinglistid`)
	) ENGINE=MyISAM
");
self::report('Created Table', 'dbtech_vbmail_subscription');

self::$db->query_write("
	CREATE TABLE IF NOT EXISTS `" . TABLE_PREFIX  . "dbtech_vbmail_template` (
		`templateid` int(10) unsigned NOT NULL AUTO_INCREMENT,
		`mailinglistid` int(10) unsigned NOT NULL DEFAULT '0',
		`subject` varchar(250) NOT NULL,
		`message` mediumtext,
		`dateline` int(10) unsigned NOT NULL DEFAULT '0',
		`permanent` enum('0','1') NOT NULL DEFAULT '1',
		PRIMARY KEY (`templateid`),
		KEY `mailinglistid` (`mailinglistid`)
	) ENGINE=MyISAM
");
self::report('Created Table', 'dbtech_vbmail_template');